/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.LongListEntry;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class LongFieldBuilder
extends FieldBuilder<Long, LongListEntry> {
    private Consumer<Long> saveConsumer = null;
    private Function<Long, Optional<Component[]>> tooltipSupplier = l -> Optional.empty();
    private final long value;
    private Long min = null;
    private Long max = null;

    public LongFieldBuilder(Component resetButtonKey, Component fieldNameKey, long value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public LongFieldBuilder setErrorSupplier(Function<Long, Optional<Component>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public LongFieldBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public LongFieldBuilder setSaveConsumer(Consumer<Long> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public LongFieldBuilder setDefaultValue(Supplier<Long> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public LongFieldBuilder setDefaultValue(long defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public LongFieldBuilder setTooltipSupplier(Supplier<Optional<Component[]>> tooltipSupplier) {
        this.tooltipSupplier = l -> (Optional)tooltipSupplier.get();
        return this;
    }

    public LongFieldBuilder setTooltipSupplier(Function<Long, Optional<Component[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public LongFieldBuilder setTooltip(Optional<Component[]> tooltip) {
        this.tooltipSupplier = l -> tooltip;
        return this;
    }

    public LongFieldBuilder setTooltip(Component ... tooltip) {
        this.tooltipSupplier = l -> Optional.ofNullable(tooltip);
        return this;
    }

    public LongFieldBuilder setMin(long min) {
        this.min = min;
        return this;
    }

    public LongFieldBuilder setMax(long max) {
        this.max = max;
        return this;
    }

    public LongFieldBuilder removeMin() {
        this.min = null;
        return this;
    }

    public LongFieldBuilder removeMax() {
        this.max = null;
        return this;
    }

    @Override
    @NotNull
    public LongListEntry build() {
        LongListEntry entry = new LongListEntry(this.getFieldNameKey(), this.value, this.getResetButtonKey(), this.defaultValue, this.saveConsumer, null, this.isRequireRestart());
        if (this.min != null) {
            entry.setMinimum(this.min);
        }
        if (this.max != null) {
            entry.setMaximum(this.max);
        }
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

